<?php

namespace app\api\controller;

use app\common\controller\Api;

class SendSms extends Api
{
    protected $noNeedLogin = '*';
    protected $noNeedRight = '*';
    /*protected $accessKeyId = '';
    protected $accessSecret = '';
    protected $SignName = '';
    protected $TemplateCode = '';*/
    

    /**
     * 发送验证码
     *
     * @param string $mobile 手机号
     * @param string $event 事件名称
     */
    public function send()
    {
        $phone = $this->request->post("phone");
        if(empty($phone)){
            return json(['code'=>2,'data'=>[],'msg'=>'手机号不能为空']);
        }
        $info=db('zsms')->where(['phone'=>$phone])->order(['createtime'=>'desc'])->find();
        if(time()-$info['createtime']<60){
            return json(['code'=>2,'data'=>[],'msg'=>'发送过于频繁,请稍后再试']);
        }
        $code = rand(1000,9999);
        
        $result=$this->sms($phone,$code);
        //$result=json_decode($result,true);
        trace($result,'info');
        if($result->Code=='OK'){
            cache('code'.$phone,$code,600);
            $data=[
                'phone'=>$phone,
                'code'=>$code,
                'ip'=>$this->request->ip(),
                'createtime'=>time()
            ];
            db('zsms')->insert($data);
            return json(['code'=>1,'data'=>[],'msg'=>'发送成功']);
            
        }else{
            return json(['code'=>2,'data'=>[],'msg'=>'发送失败']);
        }
        
    }
     
    private function sms($phone,$code)
    {
        vendor('aliyunsms/api_demo/SmsDemo');
        $sms = new \SmsDemo();
        $res = $sms->sendSms($phone,$code);
        return $res;
    }
}